function [ cp,cd ] = TriangleClosestPoint(c,p,q,r )
% cp = TriangleClosestPoint(c,p,q,r)
%
% Find the point on the triangle (p,q,r) that is closest to point c
%
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

    M = [q.el-p.el, r.el-p.el];
    x = lscov(M,c.el-p.el);
    lam = x(1); mu = x(2);
    if lam >=0 
        if mu >=0
            if lam+mu<=1
                cp = vct3((1-lam-mu)*p.el+lam*q.el+mu*r.el);
                cd = norm(cp-c);
            else
                [cp,cd] = SegmentClosestPoint(c,q,r);
            end
        else
            [cp,cd] = SegmentClosestPoint(c,p,q);
        end
    else
        [cp,cd] = SegmentClosestPoint(c,r,p);
    end
end

